-- events for story screen

timer = 0
scaleoffset = 0
rotationoffset = 0

function OnLoad ()
	CacheSound ("music/interlude.ogg");
	CacheSound ("music/episodestart.ogg");
end;

function OnEnter ()
    Reset()
 	SetProperty ("/Storyscreen:enter_trans_duration", 3.6);
    SetProperty ("/Storyscreen:leave_trans_duration", 1);
	SwitchMusic ("music/interlude.ogg", 2, 3);	
	PlaySound ("music/episodestart.ogg")
end;

function OnLeave ()

end;

function Reset ()
   timer = 0
   scaleoffset = 0.8
   rotationoffset = 18
end;

function OnClick (name)

	Print ("OnClick " .. name .. "\n");
		
	if (name == "Continue") then			
		PopScreen ("Storyscreen");
		return;
	end;
end;


function OnUpdate (tdelta)

    timer = timer + tdelta;    
	akey = GetActiveScreenAnimKey ();	
	alpha = GetActiveScreenTransPhase();
	
    SetProperty ("story:scale", 1.0 - (scaleoffset* (1-GetActiveScreenTransPhase())))
    SetProperty ("story:angle", 0 - (rotationoffset* (1-GetActiveScreenTransPhase())))
    SetProperty ("story:position_offset.y", -200 * (1-GetActiveScreenTransPhase()))
    SetProperty ("story_text:alpha", GetActiveScreenTransPhase())
    
    SetProperty ("bg:alpha", GetActiveScreenTransPhase()*2)
    
end;

function OnDraw ()

end;
